import sys

from flask import Flask, request
from werkzeug.utils import secure_filename
import os

from alibabacloud_sample.sample import Sample

app = Flask(__name__)
app.config['UPLOAD_FOLDER'] = 'uploads'  # 替换为你的上传文件夹路径


@app.route('/api/upload', methods=['POST'])
def upload_file():
    file_type = request.form.get('type')

    if 'file' not in request.files:
        return "No file part"
    file = request.files['file']
    if file.filename == '':
        return "No selected file"
    if file:  # 这里可以加文件类型判断逻辑
        directory = os.path.join(app.config['UPLOAD_FOLDER'])
        if not os.path.exists(directory):
            os.makedirs(directory)
            print(f"Directory '{directory}' created successfully.")
        else:
            print(f"Directory '{directory}' already exists.")

        filename = secure_filename(file.filename)
        print(f'filename: {filename}')
        file.save(os.path.join(app.config['UPLOAD_FOLDER'], filename))
        # 识别
        far, ticket_number = Sample.main(sys.argv[1:], filename, file_type)
        return f'{far}, {ticket_number}'
        # return 'upload success'


@app.route('/api/ocr', methods=['GET'])
def get_pic_content():
    far, ticket_number = Sample.main(sys.argv[1:], 'uploads/20240301172645.jpg', 'TrainTicket')
    return f'{far}, {ticket_number}'


@app.route('/', methods=['GET'])
def hello():
    return {
        'message': 'Hello World!'
    }


if __name__ == '__main__':
    # app.run(host='0.0.0.0', port=8000, debug=True)
    app.run(port=8000, debug=True)
