# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
import json
import os
import sys

from typing import List, Tuple, Any

from alibabacloud_ocr_api20210707.client import Client as ocr_api20210707Client
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_darabonba_stream.client import Client as StreamClient
from alibabacloud_ocr_api20210707 import models as ocr_api_20210707_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_tea_console.client import Client as ConsoleClient
from alibabacloud_tea_util.client import Client as UtilClient


class Sample:
    def __init__(self):
        pass

    @staticmethod
    def create_client() -> ocr_api20210707Client:
        """
        使用AK&SK初始化账号Client
        @return: Client
        @throws Exception
        """
        # 工程代码泄露可能会导致 AccessKey 泄露，并威胁账号下所有资源的安全性。以下代码示例仅供参考。
        # 建议使用更安全的 STS 方式，更多鉴权访问方式请参见：https://help.aliyun.com/document_detail/378659.html。
        config = open_api_models.Config(
            # 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_ID。,
            # access_key_id=os.environ['ALIBABA_CLOUD_ACCESS_KEY_ID'],
            access_key_id='LTAI5tSreWTgmQoCNE8NwKqn',
            # 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_SECRET。,
            # access_key_secret=os.environ['ALIBABA_CLOUD_ACCESS_KEY_SECRET']
            access_key_secret='re273RJmgwt1Oh8uVZGweSaAggll9o'
        )
        # Endpoint 请参考 https://api.aliyun.com/product/ocr-api
        config.endpoint = f'ocr-api.cn-hangzhou.aliyuncs.com'
        return ocr_api20210707Client(config)

    @staticmethod
    def main(
            args: List[str],
            pic_path,
            ocr_type
    ) -> tuple[Any, Any]:
        far = None
        ticket_number = None

        client = Sample.create_client()
        # 需要安装额外的依赖库，直接点击下载完整工程即可看到所有依赖。
        body_stream = StreamClient.read_from_file_path(pic_path)
        recognize_all_text_request = ocr_api_20210707_models.RecognizeAllTextRequest(
            body=body_stream,
            type=ocr_type,
            output_figure=False,
            output_qrcode=False
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = client.recognize_all_text_with_options(recognize_all_text_request, runtime)
            ConsoleClient.log(UtilClient.to_jsonstring(resp))
            data = json.loads(UtilClient.to_jsonstring(resp))
            if data['statusCode'] == 200:
                far = data['body']['Data']['SubImages'][0]['KvInfo']['KvDetails']['fare']['Value']
                ticket_number = data['body']['Data']['SubImages'][0]['KvInfo']['Data']['ticketNumber']
                ConsoleClient.log("far:" + far)
                ConsoleClient.log("ticketNumber:" + ticket_number)

        except Exception as error:
            # 此处仅做打印展示，请谨慎对待异常处理，在工程项目中切勿直接忽略异常。
            # 错误 message
            print(error.message)
            # 诊断地址
            print(error.data.get("Recommend"))
            UtilClient.assert_as_string(error.message)

        return far, ticket_number

    @staticmethod
    async def main_async(
            args: List[str],
    ) -> None:
        client = Sample.create_client()
        # 需要安装额外的依赖库，直接点击下载完整工程即可看到所有依赖。
        body_stream = StreamClient.read_from_file_path('uploads/20240301172645.jpg')
        recognize_all_text_request = ocr_api_20210707_models.RecognizeAllTextRequest(
            body=body_stream,
            type='TrainTicket',
            output_figure=False,
            output_qrcode=False
        )
        runtime = util_models.RuntimeOptions()
        try:
            resp = await client.recognize_all_text_with_options_async(recognize_all_text_request, runtime)
            ConsoleClient.log(UtilClient.to_jsonstring(resp))
        except Exception as error:
            # 此处仅做打印展示，请谨慎对待异常处理，在工程项目中切勿直接忽略异常。
            # 错误 message
            print(error.message)
            # 诊断地址
            print(error.data.get("Recommend"))
            UtilClient.assert_as_string(error.message)


if __name__ == '__main__':
    Sample.main(sys.argv[1:], 'uploads/20240301172645.jpg', 'TrainTicket')

